/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.dimensions.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.math.Vector3d;
import com.mojang.serialization.Lifecycle;
import dev.ftb.ftbsbc.FTBStoneBlock;
import dev.ftb.ftbsbc.dimensions.level.DimensionStorage;
import dev.ftb.ftbsbc.dimensions.level.stoneblock.StoneblockChunkGenerator;
import dev.ftb.ftbsbc.dimensions.net.UpdateDimensionsList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.io.FileUtils;

public class DynamicDimensionManager {
    public static ServerLevel create(MinecraftServer server, ResourceKey<Level> key, ResourceLocation prebuiltStructure) {
        Map map = server.forgeGetWorldMap();
        ServerLevel existingLevel = (ServerLevel)map.get(key);
        if (existingLevel != null) {
            return existingLevel;
        }
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)key.m_135782_());
        Holder typeHolder = registryAccess.m_175515_(Registry.f_122818_).m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)new ResourceLocation("ftbsbc", "stoneblock")));
        StoneblockChunkGenerator chunkGenerator = new StoneblockChunkGenerator((Registry<StructureSet>)registryAccess.m_175515_(Registry.f_211073_), (Registry<NormalNoise.NoiseParameters>)registryAccess.m_175515_(Registry.f_194568_), (Registry<Biome>)registryAccess.m_175515_(Registry.f_122885_), prebuiltStructure);
        LevelStem dimension = new LevelStem(typeHolder, (ChunkGenerator)chunkGenerator);
        ChunkProgressListener chunkProgressListener = server.f_129756_.m_9620_(11);
        WorldData worldData = server.m_129910_();
        WorldGenSettings worldGenSettings = worldData.m_5961_();
        DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, worldData.m_5996_());
        ((MappedRegistry)worldGenSettings.m_204655_()).m_203505_(dimensionKey, (Object)dimension, Lifecycle.stable());
        ServerLevel newWorld = new ServerLevel(server, server.f_129738_, server.f_129744_, (ServerLevelData)derivedLevelData, key, dimension.m_204521_(), chunkProgressListener, dimension.m_63990_(), worldGenSettings.m_64668_(), BiomeManager.m_47877_((long)worldGenSettings.m_64619_()), (List)ImmutableList.of(), false);
        overworld.m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newWorld.m_6857_()));
        map.put(key, newWorld);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((LevelAccessor)newWorld));
        new UpdateDimensionsList(key, true).sendToAll(server);
        return newWorld;
    }

    public static ServerLevel destroy(MinecraftServer server, ResourceKey<Level> key) {
        WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        Path dimensionPath = server.f_129744_.m_197394_(key);
        ServerLevel removedLevel = (ServerLevel)server.forgeGetWorldMap().remove(key);
        if (removedLevel == null) {
            return null;
        }
        for (ServerPlayer player : Lists.newArrayList((Iterable)removedLevel.m_6907_())) {
            ResourceKey respawnKey = Level.f_46428_;
            ServerLevel destinationLevel = server.m_129880_(respawnKey);
            BlockPos destinationPos = player.m_8961_();
            if (destinationPos == null) {
                destinationPos = destinationLevel.m_8900_();
            }
            float respawnAngle = player.m_8962_();
            player.m_8999_(destinationLevel, (double)destinationPos.m_123341_(), (double)destinationPos.m_123342_(), (double)destinationPos.m_123343_(), respawnAngle, 0.0f);
        }
        removedLevel.m_8643_(null, false, removedLevel.m_7441_());
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((LevelAccessor)removedLevel));
        WorldBorder overworldBorder = overworld.m_6857_();
        WorldBorder removedWorldBorder = removedLevel.m_6857_();
        BorderChangeListener targetListener = null;
        for (BorderChangeListener listener : overworldBorder.f_61905_) {
            if (!(listener instanceof BorderChangeListener.DelegateBorderChangeListener) || removedWorldBorder != ((BorderChangeListener.DelegateBorderChangeListener)listener).f_61864_) continue;
            targetListener = listener;
            break;
        }
        if (targetListener != null) {
            overworldBorder.m_156096_(targetListener);
        }
        Registry oldRegistry = worldGenSettings.m_204655_();
        MappedRegistry newRegistry = new MappedRegistry(Registry.f_122820_, oldRegistry.m_7837_(), null);
        for (Map.Entry entry : oldRegistry.m_6579_()) {
            ResourceKey oldKey = (ResourceKey)entry.getKey();
            ResourceKey oldLevelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)oldKey.m_135782_());
            LevelStem dimension = (LevelStem)entry.getValue();
            if (oldKey == null || dimension == null || oldLevelKey == key) continue;
            newRegistry.m_203505_(oldKey, (Object)dimension, oldRegistry.m_6228_((Object)dimension));
        }
        if (Files.exists(dimensionPath, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)dimensionPath.toFile());
            }
            catch (IOException e) {
                FTBStoneBlock.LOGGER.error("Failed to delete dimension file for {} at {}", key, (Object)dimensionPath, (Object)e);
            }
        }
        worldGenSettings.f_64605_ = newRegistry;
        server.markWorldsDirty();
        new UpdateDimensionsList(key, false).sendToAll(server);
        return removedLevel;
    }

    public static boolean teleport(ServerPlayer player, ResourceKey<Level> key) {
        ServerLevel level = player.f_8924_.m_129880_(key);
        if (level != null) {
            if (key.equals((Object)Level.f_46428_)) {
                BlockPos lobbySpawnPos = DimensionStorage.get(player.f_8924_).getLobbySpawnPos();
                player.m_8999_(level, (double)lobbySpawnPos.m_123341_() + 0.5, (double)lobbySpawnPos.m_123342_() + 0.01, (double)lobbySpawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            } else {
                Vector3d vec = new Vector3d(0.5, 1.1, 0.5);
                BlockPos respawnPosition = player.m_8961_();
                if (player.m_8963_().equals(key) && respawnPosition != null) {
                    vec.m_176291_(new Vector3d((double)respawnPosition.m_123341_(), (double)respawnPosition.m_123342_(), (double)respawnPosition.m_123343_()));
                } else {
                    BlockPos levelSharedSpawn = DimensionStorage.get(player.f_8924_).getDimensionSpawnLocations(level.m_46472_().m_135782_());
                    if (levelSharedSpawn == null) {
                        levelSharedSpawn = BlockPos.f_121853_;
                    }
                    vec.m_176291_(new Vector3d((double)levelSharedSpawn.m_123341_(), (double)levelSharedSpawn.m_123342_(), (double)levelSharedSpawn.m_123343_()));
                }
                player.m_8999_(level, vec.f_86214_, vec.f_86215_, vec.f_86216_, player.m_146908_(), player.m_146909_());
            }
            return true;
        }
        FTBStoneBlock.LOGGER.error("Failed to teleport " + player.m_6302_() + " to " + key.m_135782_());
        return false;
    }
}

